import streamlit as st
from bertopic import BERTopic


@st.cache_resource
def load_model():
    return BERTopic.load(r"Models/topic_key_model_130.pkl")


bertopic_model = load_model()


def topic_model_results():
    st.title("Topic Model Results")
    tab1, tab2, tab3, tab4, tab5 = st.tabs(
        [
            "Topic Word Score",
            "Intertopic Distance Map",
            "Topic Probability Distribution",
            "Visualize Hierarchical Topics",
            "Visualize Topics Heatmap",
        ]
    )
    with tab1:
        with st.spinner("Loading the Visualization..."):
            st.write(bertopic_model.visualize_barchart(top_n_topics=20))
    with tab2:
        with st.spinner("Loading the Visualization..."):
            st.write(bertopic_model.visualize_topics())
    with tab3:
        with st.spinner("Loading the Visualization..."):
            st.write(
                bertopic_model.visualize_distribution(
                    bertopic_model.probabilities_[0], min_probability=0.015
                )
            )
    with tab4:
        with st.spinner("Loading the Visualization..."):
            st.write(bertopic_model.visualize_hierarchy())
    with tab5:
        with st.spinner("Loading the Visualization..."):
            st.write(bertopic_model.visualize_heatmap())


if __name__ == "__main__":
    topic_model_results()
